
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   MSG1135.C - Message 1135 Processing
// 
//
//   DESCRIPTION
//
//   Functions to decode, build, and display Zodiac 1135 messages.
//
//
//   REVISION HISTORY
//
//   $Log:   V:\Projects\Labmon\Source\Archives\MSG1135.C_v  $
//   
//      Rev 1.16   08 Dec 1999 16:24:04   phungh
//   Add "MAGNA CONTROL" string to screen
//   display when MAGNA CONTROL is changed
//   
//      Rev 1.15   09 Nov 1998 10:47:52   phungh
//   labmon51: Fix file logging and missing
//   logged data bugs.  Changes made to the 
//   "Pause" variable ( 1 -> 0 ) to allow main
//   loop continue.  Move the "write to file"
//   code portion out of the interrupt handler
//   so that data is not missed because of time
//   spent too long in the interrupt handler
//   
//      Rev 1.3   Jul 09 1997 10:42:12   COLEJ
//    
//   
//      Rev 1.2   Feb 12 1997 16:05:28   COLEJ
//    
//   
//      Rev 1.1   Aug 14 1996 10:06:12   COLEJ
//    
//   
//      Rev 1.0   13 May 1996 14:52:58   GPSADMIN
//   Initial release to version control.
//
//
////////////////////////////////////////////////////////////////////////////////

#include "gentypes.h"
#include "gencons.h"
#include "ztypes.h"
#include "zcons.h"   
#include "util.h" 
#include "display.h"

#include "stdio.h" 

void wait(float);  
void clear_message_line(void);   

tSHORT i;

////////////////////////////////////////////////////////////////////////////////
//   
//   Decode a Zodiac 1135 message from the ZMsgBuf.
//
void Dec1135(tMSGBUF *ZMsgBuf, tMSG1135 *Msg)
{
   GetBits   (&EEPROMUpdateData.DataId , ZMsgBuf, 9, 0, 8); // ND
   GetBits   (&EEPROMUpdateData.PRN    , ZMsgBuf, 9, 8, 8); // ND
}                                      
                                     
////////////////////////////////////////////////////////////////////////////////
//   
//   Build a Zodiac 1135 message in the ZMsgBuf. 
//
void Bld1135(tMSGBUF *ZMsgBuf, tMSG1135 *Msg)
{
   // ack flags assumed preset

   PutShort  (0x81FF                        , ZMsgBuf, 1);       // message preamble
   PutShort  (1135                          , ZMsgBuf, 2);       // message number
   PutShort  (4                             , ZMsgBuf, 3);       // message length 
   PutShort  (ANREQ                         , ZMsgBuf, 4);       // message ack/nack request
 //PutShort  (CheckSum(ZMsgBuf[0], 4)       , ZMsgBuf, 5);       // header check sum
                                                  
   PutBits   (EEPROMUpdateData.DataId  , ZMsgBuf, 9, 0, 8); // ND   
   PutBits   (EEPROMUpdateData.PRN     , ZMsgBuf, 9, 7, 8); // ND   
 //PutShort  (CheckSum(ZMsgBuf, 6, 4)       , ZMsgBuf,10);       // data check sum 
}

////////////////////////////////////////////////////////////////////////////////
//   
//   Display a Zodiac 1135 message from the ZMsgBuf.
//
void Show1135(tMSG1135 *Msg)
{
   char    Buf[100] = "";
   char    *DataIdName[30] =
            {"STATUS", "POSITION", "UTC/IONO", "FREQUENCY STD CUBIC PARAMETERS", 
             "HOST PORT COMM CONFIG", "AUX PORT COMM CONFIG", "MEMORY OPTIONS",
             "SOLUTION VALIDITY CRITERIA", "POWER MANAGEMENT SELECTION", 
             "SELECTED DATUM", "PLATFORM CLASS", "COLD START CONTROL", 
             "ELEVATION MASK ANGLE", "SATELLITE CANDIDATE LIST", 
             "ANTENNA SELECTION", "USER ENTERED ALTITUDE", "DGPS CONTROL", 
             "HOST PORT PROTOCOL SELECTION", "AUXILIARY PORT PROTOCOL SELECTION", 
             "HOST PORT ENABLED MESSAGES", "AUXILIARY PORT ENABLED MESSAGES", 
             "USER DATUMS", "FREQUENCY/TEMPERATURE TABLE", "ALMANAC",
             "FREQUENCY STANDARD CALIBRATION", "NAV CONFIGURATION DATA",
             "DR NAV PARAMETERS", "GYRO TEMPERATURE TABLE", 
             "MAGNA CONTROL", " "}; 

   // perform special processing for output
   
   if(EEPROMUpdateData.DataId == 23){
      sprintf(Buf,"MSG 1135: DATA ID: %d  TYPE: %s  PRN: %d", 
               EEPROMUpdateData.DataId, 
               DataIdName[(short) EEPROMUpdateData.DataId],
               EEPROMUpdateData.PRN); 
   }
   else{
      sprintf(Buf,"MSG 1135: DATA ID: %d  TYPE: %s", 
               EEPROMUpdateData.DataId, 
               DataIdName[(short) EEPROMUpdateData.DataId]);   
   }

   // output the data items   
   clear_message_line();                                                                                               
   ShowText(Buf,CMDR   ,CMDC   );  
   wait(.5f);
}                                                 
                                      
                                           
